<?php
namespace BdevsElementor\Widget;

use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;

/**
 * Bdevs Elementor Widget.
 *
 * Elementor widget that inserts an embbedable content into the page, from any given URL.
 *
 * @since 1.0.0
 */
class BdevsSlider extends \Elementor\Widget_Base {

    /**
     * Get widget name.
     *
     * Retrieve Bdevs Elementor widget name.
     *
     * @since 1.0.0
     * @access public
     *
     * @return string Widget name.
     */
    public function get_name() {
        return 'bdevs-slider';
    }

    /**
     * Get widget title.
     *
     * Retrieve Bdevs Elementor widget title.
     *
     * @since 1.0.0
     * @access public
     *
     * @return string Widget title.
     */
    public function get_title() {
        return __( 'Slider', 'bdevs-elementor' );
    }

    /**
     * Get widget icon.
     *
     * Retrieve Bdevs About widget icon.
     *
     * @since 1.0.0
     * @access public
     *
     * @return string Widget icon.
     */
    public function get_icon() {
        return 'eicon-post-slider';
    }

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the Bdevs About widget belongs to.
     *
     * @since 1.0.0
     * @access public
     *
     * @return array Widget categories.
     */
    public function get_categories() {
        return [ 'bdevs-elementor' ];
    }

    public function get_keywords() {
        return [ 'slider' ];
    }

    public function get_script_depends() {
        return [ 'bdevs-elementor'];
    }

    // BDT Position
    protected function element_pack_position() {
        $position_options = [
            ''              => esc_html__('Default', 'bdevs-elementor'),
            'top-left'      => esc_html__('Top Left', 'bdevs-elementor') ,
            'top-center'    => esc_html__('Top Center', 'bdevs-elementor') ,
            'top-right'     => esc_html__('Top Right', 'bdevs-elementor') ,
            'center'        => esc_html__('Center', 'bdevs-elementor') ,
            'center-left'   => esc_html__('Center Left', 'bdevs-elementor') ,
            'center-right'  => esc_html__('Center Right', 'bdevs-elementor') ,
            'bottom-left'   => esc_html__('Bottom Left', 'bdevs-elementor') ,
            'bottom-center' => esc_html__('Bottom Center', 'bdevs-elementor') ,
            'bottom-right'  => esc_html__('Bottom Right', 'bdevs-elementor') ,
        ];

        return $position_options;
    }

    protected function _register_controls() {
        
        $this->start_controls_section(
            'section_content_heading',
            [
                'label' => esc_html__( 'Slider', 'bdevs-elementor' ),
            ]   
        );
    
        $this->add_control(
            'tabs',
            [
                'label' => esc_html__( 'Items', 'bdevs-elementor' ),
                'type' => Controls_Manager::REPEATER,
                'fields' => [
                    [
                        'name'    => 'background_image',
                        'label'   => esc_html__( 'Image', 'bdevs-elementor' ),
                        'type'    => Controls_Manager::MEDIA,
                        'dynamic' => [ 'active' => true ],
                    ],
                    [
                        'name'        => 'heading',
                        'label'       => esc_html__( 'Heading:', 'bdevs-elementor' ),
                        'type'        => Controls_Manager::TEXT,
                        'dynamic'     => [ 'active' => true ],
                        'default'     => esc_html__( 'This is heading' , 'bdevs-elementor' ),
                        'label_block' => true,
                    ],
                    [
                        'name'        => 'description',
                        'label'       => esc_html__( 'Description:', 'bdevs-elementor' ),
                        'type'        => Controls_Manager::TEXTAREA,
                        'dynamic'     => [ 'active' => true ],
                        'default'     => esc_html__( 'This is description' , 'bdevs-elementor' ),
                        'label_block' => true,
                    ],
                    [
                        'name'        => 'link_button',
                        'label'       => esc_html__( 'Link Button:', 'bdevs-elementor' ),
                        'type'        => Controls_Manager::TEXT,
                        'dynamic'     => [ 'active' => true ],
                        'default'     => esc_html__( '#' , 'bdevs-elementor' ),
                        'label_block' => true,
                    ],
                    [
                        'name'        => 'button',
                        'label'       => esc_html__( 'Button:', 'bdevs-elementor' ),
                        'type'        => Controls_Manager::TEXT,
                        'dynamic'     => [ 'active' => true ],
                        'default'     => esc_html__( 'Know More' , 'bdevs-elementor' ),
                        'label_block' => true,
                    ],
                    [
                        'name'        => 'link_button_2',
                        'label'       => esc_html__( 'Link Button 2:', 'bdevs-elementor' ),
                        'type'        => Controls_Manager::TEXT,
                        'dynamic'     => [ 'active' => true ],
                        'default'     => esc_html__( '#' , 'bdevs-elementor' ),
                        'label_block' => true,
                    ],
                    [
                        'name'        => 'button_2',
                        'label'       => esc_html__( 'Button 2:', 'bdevs-elementor' ),
                        'type'        => Controls_Manager::TEXT,
                        'dynamic'     => [ 'active' => true ],
                        'default'     => esc_html__( 'Know More' , 'bdevs-elementor' ),
                        'label_block' => true,
                    ],
                ],
            ]
        );
        $this->end_controls_section();

        /** 
        *   Layout section 
        **/
        $this->start_controls_section(
            'section_content_layout',
            [
                'label' => esc_html__( 'Layout', 'bdevs-elementor' ),
            ]
        );

        $this->add_responsive_control(
            'align',
            [
                'label'   => esc_html__( 'Alignment', 'bdevs-elementor' ),
                'type'    => Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => esc_html__( 'Left', 'bdevs-elementor' ),
                        'icon'  => 'fa fa-align-left',
                    ],
                    'center' => [
                        'title' => esc_html__( 'Center', 'bdevs-elementor' ),
                        'icon'  => 'fa fa-align-center',
                    ],
                    'right' => [
                        'title' => esc_html__( 'Right', 'bdevs-elementor' ),
                        'icon'  => 'fa fa-align-right',
                    ],
                    'justify' => [
                        'title' => esc_html__( 'Justified', 'bdevs-elementor' ),
                        'icon'  => 'fa fa-align-justify',
                    ],
                ],
                'prefix_class' => 'elementor%s-align-',
                'description'  => 'Use align to match position',
                'default'      => 'left',
            ]
        );
        $this->end_controls_section();

    }
    public function render() {
    $settings  = $this->get_settings_for_display();
    extract($settings); 
    ?>    
    <!-- Start Banner Carousel -->
    <div class="banner-outer">
        <div class="banner-slider">
            <?php 
            $i=0;
            foreach ( $settings['tabs'] as $item ) : 
            $i++;
            ?>
            <?php if($i%3==1) { ?>
            <div class="slide1" style="background-image:url(<?php echo wp_kses_post($item['background_image']['url']); ?>)">
                <div class="container">
                    <div class="content animated fadeInRight">
                        <div class="fl-right">
                            <?php if(isset($item['heading']) && $item['heading'] != ''){?>
                            <h1 class="animated fadeInRight"><?php print wp_kses_post($item['heading']); ?></h1>
                            <?php } ?>
                            <?php if(isset($item['description']) && $item['description'] != ''){?>
                            <p class="animated fadeInRight"><?php print wp_kses_post($item['description']); ?></p>
                            <?php } ?>
                            <?php if(isset($item['link_button']) && $item['link_button'] != ''){?>
                            <a href="<?php print wp_kses_post($item['link_button']); ?>" class="btn animated fadeInRight"><?php print wp_kses_post($item['button']); ?><span class="icon-more-icon"></span></a> 
                            <?php } ?>
                        </div>
                    </div>
                </div>
            </div>
            <?php } elseif($i%3==2) { ?>
            <div class="slide2" style="background-image:url(<?php echo wp_kses_post($item['background_image']['url']); ?>)">
                <div class="container">
                    <div class="content">
                        <?php if(isset($item['heading']) && $item['heading'] != ''){?>
                        <h1 class="animated fadeInUp"><?php print wp_kses_post($item['heading']); ?></h1>
                        <?php } ?>
                        <?php if(isset($item['description']) && $item['description'] != ''){?>
                        <p class="animated fadeInUp"><?php print wp_kses_post($item['description']); ?></p>
                        <?php } ?>
                        <?php if(isset($item['link_button']) && $item['link_button'] != ''){?>
                        <a href="<?php print wp_kses_post($item['link_button']); ?>" class="btn animated fadeInUp"><?php print wp_kses_post($item['button']); ?><span class="icon-more-icon"></span></a> 
                        <?php } ?>
                        <?php if(isset($item['link_button_2']) && $item['link_button_2'] != ''){?>
                        <a href="<?php print wp_kses_post($item['link_button_2']); ?>" class="btn white animated fadeInUp hidden-xs"><?php print wp_kses_post($item['button_2']); ?><span class="icon-more-icon"></span></a> 
                        <?php } ?>
                    </div>
                </div>
            </div>
            <?php } elseif($i%3==0) { ?>
            <div class="slide3" style="background-image:url(<?php echo wp_kses_post($item['background_image']['url']); ?>)">
                <div class="container">
                    <div class="content animated fadeInLeft">
                        <?php if(isset($item['heading']) && $item['heading'] != ''){?>
                        <h1 class="animated fadeInLeft"><?php print wp_kses_post($item['heading']); ?></h1>
                        <?php } ?>
                        <?php if(isset($item['description']) && $item['description'] != ''){?>
                        <p class="animated fadeInLeft"><?php print wp_kses_post($item['description']); ?></p>
                        <?php } ?>
                        <?php if(isset($item['link_button']) && $item['link_button'] != ''){?>
                        <a href="<?php print wp_kses_post($item['link_button']); ?>" class="btn animated fadeInLeft"><?php print wp_kses_post($item['button']); ?><span class="icon-more-icon"></span></a> 
                        <?php } ?>
                    </div>
                </div>
            </div>
            <?php } ?>
            <?php endforeach; ?>
        </div>
    </div>
    <!-- End Banner Carousel --> 
    <?php
    }

}


