<?php
// register post type Gallery
add_action( 'init', 'register_edumart_gallery' );

function register_edumart_gallery() {

    $labels = array( 
        'name' => __( 'Gallery', 'edumart' ),

        'singular_name' => __( 'Gallery', 'edumart' ),

        'add_new' => __( 'Add New Gallery', 'edumart' ),

        'add_new_item' => __( 'Add New Gallery', 'edumart' ),

        'edit_item' => __( 'Edit Gallery', 'edumart' ),

        'new_item' => __( 'New Gallery', 'edumart' ),

        'view_item' => __( 'View Gallery', 'edumart' ),

        'search_items' => __( 'Search Gallery', 'edumart' ),

        'not_found' => __( 'No Gallery found', 'edumart' ),

        'not_found_in_trash' => __( 'No Gallery found in Trash', 'edumart' ),

        'parent_item_colon' => __( 'Parent Gallery:', 'edumart' ),

        'menu_name' => __( 'Gallery', 'edumart' ),

    );

    $args = array( 
        'labels' => $labels,

        'hierarchical' => true,

        'description' => 'Gallery',

        'supports' => array( 'title', 'editor', 'thumbnail', 'comments'),

        'taxonomies' => array( 'gallery', 'type1','category1' ),

        'public' => true,

        'show_ui' => true,

        'show_in_menu' => true,

        'menu_position' => 5,

        'menu_icon' => 'dashicons-format-gallery', 

        'show_in_nav_menus' => true,

        'publicly_queryable' => true,

        'exclude_from_search' => false,

        'has_archive' => true,

        'query_var' => true,

        'can_export' => true,

        'rewrite' => true,

        'capability_type' => 'post'
    );
    register_post_type( 'gallery', $args );
}

add_action( 'init', 'create_type1_hierarchical_taxonomy', 0 );
add_action( 'init', 'create_category1_hierarchical_taxonomy', 0 );

//create a custom taxonomy name it Skillss for your posts
function create_Type1_hierarchical_taxonomy() {
    // Add new taxonomy, make it hierarchical like Skills
    //first do the translations part for GUI
    $labels = array(

        'name' => __( 'Type', 'edumart' ),

        'singular_name' => __( 'Type', 'edumart' ),

        'search_items' =>  __( 'Search Type','edumart' ),

        'all_items' => __( 'All Type','edumart' ),

        'parent_item' => __( 'Parent Type','edumart' ),

        'parent_item_colon' => __( 'Parent Type:','edumart' ),

        'edit_item' => __( 'Edit Type','edumart' ), 

        'update_item' => __( 'Update Type','edumart' ),

        'add_new_item' => __( 'Add New Type','edumart' ),

        'new_item_name' => __( 'New Type Name','edumart' ),

        'menu_name' => __( 'Type','edumart' ),

    );     
    // Now register the taxonomy
    register_taxonomy('type1',array('gallery'), array(

        'hierarchical' => true,

        'labels' => $labels,

        'show_ui' => true,

        'show_admin_column' => true,

        'query_var' => true,

        'rewrite' => array( 'slug' => 'type1' ),
    ));
}

function create_category1_hierarchical_taxonomy() {
    // Add new taxonomy, make it hierarchical like Skills
    //first do the translations part for GUI
    $labels = array(
        'name' => __( 'Category', 'edumart' ),
        'singular_name' => __( 'Category', 'edumart' ),
        'search_items' =>  __( 'Search Category','edumart' ),
        'all_items' => __( 'All Category','edumart' ),
        'parent_item' => __( 'Parent Category','edumart' ),
        'parent_item_colon' => __( 'Parent Category:','edumart' ),
        'edit_item' => __( 'Edit Category','edumart' ), 
        'update_item' => __( 'Update Category','edumart' ),
        'add_new_item' => __( 'Add New Category','edumart' ),
        'new_item_name' => __( 'New Category Name','edumart' ),
        'menu_name' => __( 'Category','edumart' ),
    );     
    // Now register the taxonomy
    register_taxonomy('category1',array('gallery'), array(
        'hierarchical' => true,
        'labels' => $labels,
        'show_ui' => true,
        'show_admin_column' => true,
        'query_var' => true,
        'rewrite' => array( 'slug' => 'category1' ),
    ));
}
add_action( 'init', 'register_edumart_course' );

function register_edumart_course() {

    $labels = array( 
        'name' => __( 'Course', 'edumart' ),

        'singular_name' => __( 'Course', 'edumart' ),

        'add_new' => __( 'Add New Course', 'edumart' ),

        'add_new_item' => __( 'Add New Course', 'edumart' ),

        'edit_item' => __( 'Edit Course', 'edumart' ),

        'new_item' => __( 'New Course', 'edumart' ),

        'view_item' => __( 'View Course', 'edumart' ),

        'search_items' => __( 'Search Course', 'edumart' ),

        'not_found' => __( 'No Course found', 'edumart' ),

        'not_found_in_trash' => __( 'No Course found in Trash', 'edumart' ),

        'parent_item_colon' => __( 'Parent Course:', 'edumart' ),

        'menu_name' => __( 'Course', 'edumart' ),

    );

    $args = array( 
        'labels' => $labels,

        'hierarchical' => true,

        'description' => 'Course',

        'supports' => array( 'title', 'editor', 'thumbnail', 'comments'),

        'taxonomies' => array( 'course', 'type2','category2' ),

        'public' => true,

        'show_ui' => true,

        'show_in_menu' => true,

        'menu_position' => 5,

        'menu_icon' => 'dashicons-welcome-learn-more', 

        'show_in_nav_menus' => true,

        'publicly_queryable' => true,

        'exclude_from_search' => false,

        'has_archive' => true,

        'query_var' => true,

        'can_export' => true,

        'rewrite' => true,

        'capability_type' => 'post'
    );
    register_post_type( 'course', $args );
}

add_action( 'init', 'create_type2_hierarchical_taxonomy', 0 );
add_action( 'init', 'create_category2_hierarchical_taxonomy', 0 );

//create a custom taxonomy name it Skillss for your posts
function create_Type2_hierarchical_taxonomy() {
    // Add new taxonomy, make it hierarchical like Skills
    //first do the translations part for GUI
    $labels = array(

        'name' => __( 'Type', 'edumart' ),

        'singular_name' => __( 'Type', 'edumart' ),

        'search_items' =>  __( 'Search Type','edumart' ),

        'all_items' => __( 'All Type','edumart' ),

        'parent_item' => __( 'Parent Type','edumart' ),

        'parent_item_colon' => __( 'Parent Type:','edumart' ),

        'edit_item' => __( 'Edit Type','edumart' ), 

        'update_item' => __( 'Update Type','edumart' ),

        'add_new_item' => __( 'Add New Type','edumart' ),

        'new_item_name' => __( 'New Type Name','edumart' ),

        'menu_name' => __( 'Type','edumart' ),

    );     
    // Now register the taxonomy
    register_taxonomy('type2',array('course'), array(

        'hierarchical' => true,

        'labels' => $labels,

        'show_ui' => true,

        'show_admin_column' => true,

        'query_var' => true,

        'rewrite' => array( 'slug' => 'type2' ),
    ));
}

function create_category2_hierarchical_taxonomy() {
    // Add new taxonomy, make it hierarchical like Skills
    //first do the translations part for GUI
    $labels = array(
        'name' => __( 'Category', 'edumart' ),
        'singular_name' => __( 'Category', 'edumart' ),
        'search_items' =>  __( 'Search Category','edumart' ),
        'all_items' => __( 'All Category','edumart' ),
        'parent_item' => __( 'Parent Category','edumart' ),
        'parent_item_colon' => __( 'Parent Category:','edumart' ),
        'edit_item' => __( 'Edit Category','edumart' ), 
        'update_item' => __( 'Update Category','edumart' ),
        'add_new_item' => __( 'Add New Category','edumart' ),
        'new_item_name' => __( 'New Category Name','edumart' ),
        'menu_name' => __( 'Category','edumart' ),
    );     
    // Now register the taxonomy
    register_taxonomy('category2',array('course'), array(
        'hierarchical' => true,
        'labels' => $labels,
        'show_ui' => true,
        'show_admin_column' => true,
        'query_var' => true,
        'rewrite' => array( 'slug' => 'category2' ),
    ));
}
?>